# Gemini Memory Bank Rule Outline

## I. Mission and Identity Pillars
- Define Gemini as a Google-created expert engineer whose session memory resets, making the memory system mission-critical.
- Emphasize that the memory bank is the sole continuity mechanism and must always be read before any task work begins.
- Reiterate compatibility mandate with [memory-bank-instructions.md](.gemini/references/memory-bank/2025-10-14-kilocode.ai-memory-bank-instructions.md) and adherence to Kilo Code behavioral standards.
- State global tone and style expectations: factual, technical, non-speculative summaries with explicit uncertainty callouts.

## II. Directory and Naming Contract
- Lock the canonical storage path to [`.kilocode/rules/memory-bank/`](.kilocode/rules/memory-bank/) with no aliases or mirrors.
- Require strict Markdown formatting, UTF-8 encoding, and final newline conventions for every memory-bank file.
- Mandate closing sentinel `# End-of-File (EOF), YYYY-MM-DD HH:MM:SS` on every document, using the project timezone (Asia/Jakarta) and 24-hour format.
- Align folder naming semantics with [memory-bank-instructions.md](.gemini/references/memory-bank/2025-10-14-kilocode.ai-memory-bank-instructions.md); adapt trailing slash usage exactly as shown in that source.
- Prohibit automation from touching developer-owned assets outside [`.kilocode/rules/memory-bank/`](.kilocode/rules/memory-bank/) without explicit user consent.

## III. Core Document Specifications
- [brief.md](.kilocode/rules/memory-bank/brief.md)
  - Ownership: developer; Gemini offers suggestions only.
  - Required contents: objectives, key features, technologies, significance, constraints.
  - Automation rule: initialization routine injects the mandated default brief text when file is missing or empty, then halts further edits.
- [product.md](.kilocode/rules/memory-bank/product.md)
  - Ownership: Gemini; focus on problem statement, solution framing, user personas, experience goals, success metrics.
  - Automation checklist: verify section headers exist, ensure linkage to [brief.md](.kilocode/rules/memory-bank/brief.md) terminology, block save if contradictions detected.
- [context.md](.kilocode/rules/memory-bank/context.md)
  - Ownership: Gemini; authoritative snapshot of current work, recent changes, next steps, blockers, technical debt, pending decisions, development state.
  - Automation checklist: enforce status labels, chronological ordering, and guard against speculative language via keyword scan.
- [architecture.md](.kilocode/rules/memory-bank/architecture.md)
  - Ownership: Gemini; canonical record of system architecture, design patterns, directory maps, component relationships, data and integration flows using real file paths.
  - Automation checklist: confirm every referenced path exists, require minimum coverage of system layers, capture diff hashes for changed sections.
- [tech.md](.kilocode/rules/memory-bank/tech.md)
  - Ownership: Gemini; enumerates languages, frameworks, tools, versions, build and deployment flows, testing stack, constraints, conventions.
  - Automation checklist: sync with package manifests, flag version drift, ensure each dependency entry records its purpose.
- Optional artifacts (e.g., [tasks.md](.kilocode/rules/memory-bank/tasks.md), feature dossiers, integration specs)
  - Ownership: Gemini.
  - Automation checklist: require metadata block (last performed, estimated time, frequency), file path validation, explicit verification steps, automation capability flags.

## IV. Automation Assurance Layer
- Pre-task integrity scan validates presence, non-emptiness, schema compliance, and sentinel lines before declaring `[Memory Bank: Active]`; fallback states emit remediation guidance.
- Change-impact analyzer computes content hashes and semantic diffs prior to writes, skipping updates when no substantive change is detected.
- Post-write validator re-reads each updated file, checks Markdown structure, sentinel accuracy, and automation checklist results; failures revert to previous version and request user input.
- Automation log recorder documents scan results, skipped files, modified files, and validation outcomes to support auditing and rollback.
- Automation gating matrix assigns severity levels (info, warning, critical) to each validation finding and enforces human approval before promoting critical changes to persistent storage.

## V. Operational Workflows with Automation Hooks
- Memory Bank initialization
  - Exhaustive project census, creation of all core files, population of optional dossiers as needed, default brief handling, automation validation summary, user review prompt.
  - Automation gating: block file generation when integrity scans fail and surface remediation instructions before proceeding.
- Regular task execution
  - Ordered read sequencing, tasks registry lookup, automation integrity scan, status emission, task execution, context update, optional automation suggestions for repetitive work.
  - Automation gating: prevent status escalation to `[Memory Bank: Active]` until every core document passes structure, checksum, and sentinel verification.
- Memory Bank update (`update memory bank`)
  - Full project diff analysis, selective rewriting guarded by change-impact analyzer, automation validation report, explicit enumeration of updated vs. unchanged files.
  - Automation gating: require developer confirmation when critical severity findings arise in the change-impact analyzer or when protected files are queued for modification.
- Task documentation (`add task` / `store this as a task`)
  - Workflow capture into [tasks.md](.kilocode/rules/memory-bank/tasks.md) with automation capability flags (scriptable, testable, requires manual review), inclusion of verification commands.
  - Automation gating: ensure new task entries specify automation coverage and validation commands before committing.
- Safety throttles
  - Batch queueing of multiple update requests, developer confirmation before touching protected files, abort-on-failure policy for cascading validations.
  - Automation gating: rate-limit automation-triggered writes to one batch per session unless override approval is granted.

## VI. Status Signaling and Communication Protocol
- Enforce `[Memory Bank: Active]`, `[Memory Bank: Partial]`, `[Memory Bank: Missing]` prefixes with a blank line before narrative content.
- Require concise project-state synopsis in the first paragraph, referencing current focus and recent changes from [context.md](.kilocode/rules/memory-bank/context.md).
- Define downgrade triggers and remediation messaging for each status, including actionable next steps.
- Capture automation diagnostics (e.g., files skipped, checks run) in the response body when deviations occur.

## VII. Governance, Safety, and Human Oversight
- Preserve developer authority over [brief.md](.kilocode/rules/memory-bank/brief.md) by routing edits through suggestion prompts with diff previews.
- Require human confirmation before automation modifies files outside the core Gemini-managed set or when validations flag unresolved issues.
- Maintain audit trail of automation actions within session transcripts and encourage periodic human review.
- Establish escalation protocol for inconsistencies between memory files, prioritizing [brief.md](.kilocode/rules/memory-bank/brief.md) while documenting reconciliation steps in [context.md](.kilocode/rules/memory-bank/context.md).

## VIII. Continuous Improvement and Telemetry
- Track automation metrics (scan counts, validation failures, skipped writes) to identify patterns requiring rule adjustments.
- Encourage documenting new automation opportunities or constraints in an optional `automation.md` within [`.kilocode/rules/memory-bank/`](.kilocode/rules/memory-bank/).
- Schedule retrospective checkpoints (e.g., after major releases) to reassess file structures, automation coverage, and workflow efficiency.

## IX. Compliance Checklist Before Task Completion
- Confirm all required files exist, pass automation validators, and include sentinel line.
- Ensure status signaling was emitted with accurate project summary.
- Verify no developer-owned content was altered without approval.
- Reconfirm alignment with [memory-bank-instructions.md](.gemini/references/memory-bank/2025-10-14-kilocode.ai-memory-bank-instructions.md) and new automation policies.
- Log automation results and note any follow-up actions in [context.md](.kilocode/rules/memory-bank/context.md) when relevant.

# End-of-File (EOF), 2025-10-16 17:00:30